```{index} triple: DREAM3D-NX; Release Notes; 7.0.0-rc12
```

# 7.0.0-Release Candidate 12

This is the 7.0.0 Release Candidate 12. Below are listed the many bug fixes and development that have gone into this release.

## Known Issues

- Long visualization operations can lock up the GUI. Please be patient for those operations to end.

## New Features

- DREAM3D-NX User Interface layout presets
- Added search field into the Color Presets Dialog
- Dynamic scaling of the User Interface using hot keys
- Read CSV User Interface bug fixes and updates
- Visualization focal point options.
- Add ability to change the background color for visualization screenshots
- Add xyz coordinates info to hover points feature 

## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the
start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D-NX

- ENH: Implement color map presets dialog search bar (#681) [2024-05-25]
- BUG: Fix Header issues in NXReadCSVWidget (#680) [2024-05-25]
- ENH: Add ability to change the background color for visualization screenshots (#669) [2024-05-24]
- ENH: Update the preferences dialog to set the window modified flag when any changes take place (#678) [2024-05-24]
- DOC: Fixes to various documentation bugs (#679) [2024-05-23]
- BUG: Remove group separators from line edit number value when comparing with cached value (#675) [2024-05-22]
- ENH: Add ability to enable/disable python plugins (#676) [2024-05-22]
- ENH: Visualization Settings Widget Improvements (#670) [2024-05-22]
- BUG: Renamed GenerateColorTable to CreateColorMap (#672) [2024-05-21]
- BUG: Allow emitted messages from NXPipelineFilterListView to be shown in the usual places (#673) [2024-05-17]
- Fixed python reload error not being caught (#671) [2024-05-16]
- STYLE: Rewrite how NXIconPushButtons source their icons (#661) [2024-05-13]
- Fix VXCornerAnnotationSource crash. (#668) [2024-05-09]
- ENH: Add xyz coordinates info to hover points feature (#667) [2024-05-07]
- BUG: Remove the threading when reading the CSV file to find the total number of lines. (#665) [2024-05-05]
- BUG: Truncate log files on open. [2024-05-04]
- BUG: Fix hangs when closing windows that have filters that had a QtNxFileCompleter [2024-05-03]
- BUG: Fix compile error for Windows [2024-05-02]
- BUG: Fix issue where visualization preferences were not being populated on MacOS/Linux [2024-05-02]
- Update Visualization Only prebuilt layout to disclude the output window [2024-05-02]
- ENH: Advanced layout options (#659) [2024-04-30]
- BUG: Fix duplicate preflights [2024-04-30]
- BUG: Fix missing preflight when removing filters [2024-04-30]
- VERS: Update DREAM3D-NX Version for conda builds (#664) [2024-04-29]
- ENH: DataPathSelectionButton updated styling for mouse hover and click lock (#663) [2024-04-25]
- ENH: Visualization focal point options (#639) [2024-04-25]
- BUG: Fix bad character in Light Mode Style Sheet [2024-04-23]
- VER: Bump version to RC-12 [2024-04-22]

### SIMPLNX 

- ENH: Update docs for filters that change FeatureIds to warn user of invalid feature attribute matrix (#980) [2024-05-28]
- ENH/BUG: Mask Option Type Clean-Up and Out-of-Core Compatibility Update (#978) [2024-05-26]
- ENH: Add Python Plugin Environment File to generated plugin (#970) [2024-05-25]
- ENH: Update docs for Orientation Correlation/Comparison filters. (#979) [2024-05-25]
- BUG: ReadCSVFileFilter-Replace illegal characters in headers. (#977) [2024-05-25]
- ENH: Update ComputeSlipTransmissionMetrics and ComputeBoundaryStrengths docs (#974) [2024-05-24]
- FILTER: Create Peregrine Reader Filter (Python) (#965) [2024-05-24]
- ENH: Consistency in default parameter values for DataPath and DataObjectName (#972) [2024-05-24]
- DOC: Fix capitalization issue in the documentation for the GitHub link. (#975) [2024-05-23]
- DOC: Fix various documentation bugs. (#973) [2024-05-23]
- COMP: Update GitHub CI runner to use macOS 12 for x86 (#971) [2024-05-21]
- ENH: Factor Out EliminateDuplicateNodes and FillDataArray, Add Sub-Volume Reading, and Improve Error Reporting (#964) [2024-05-20]
- ENH: Rename Filters that start with Find/Generate/Calculate to Compute (#956) [2024-05-20]
- BUG: Fix crashes in SIMPL Json to SIMPLNX filter (#959) [2024-05-18]
- ENH: Add Default Extension (.csv) to WriteFeatureDataAsCSVFilter (#963) [2024-05-17]
- DOC: Add Python documentation for all Actions. (#951) [2024-05-17]
- ENH: CliReaderFilter-Add edge-bounding box intersection options (#960) [2024-05-16]
- ENH: Merge Twins Rework and Segment Features Cleanup (#955) [2024-05-14]
- Python feedback changes (#942) [2024-05-13]
- BUG: Fix parameter key for Import HDF5 Parameter (#953) [2024-05-08]
- BUG: Pipeline and Filter human facing label cleanup (#934) [2024-05-06]
- COMP: Turn warnings for inconsistent-missing-override into errors (#950) [2024-05-04]
- ENH: Python CLI Reader Bounding Box (#946) [2024-05-03]
- ENH: Moved Result handling outside of AtomicFile (#941) [2024-05-03]
- ENH: Moved StringUtilities helper functions to detail namespace (#940) [2024-05-03]
- BUG: Fix ITKImageProcessing filter UUIDs. (#945) [2024-05-02]
- ENH: RenameAction and Filter Add Overwrite Option, Result Changes (#912) [2024-05-02]
- BUG: WriteAsciiData-Add preflight checks for empty paths. (#938) [2024-05-01]
- BUG: ReadCTFData-Remove phase=0 value adjustment. (#937) [2024-05-01]
- COMP: ReadVtkStructuredPoints-Fix compiler warning about over flow in memset (#932) [2024-04-30]
- ENH: All filter's class names end with "Filter". (#931) [2024-04-29]
- BUG: Fix STLFileReader crash bug (#930) [2024-04-28]
- BUG: Filters that delete NeighborLists from the DataStructure send strong warning messages. (#926) [2024-04-28]
- API: DataPath::replaceName convenience method. (#928) [2024-04-25]
- BUG: Fix HDF5 implicit copy crashes. (#924) [2024-04-23]