```{index} triple: DREAM3D-NX; Release Notes; 7.0.0-rc6
```

# 7.0.0-Release Candidate 6

This is the 7.0.0 Release Candidate 6. Below are listed the many bug fixes and development that have gone into this release.

## Known Issues

+ The point/cell hover feature will only highlight a one face of an ImageGeometry voxel. The data is still correct.

## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D NX

| Description | Git Commit Date |
|-------------|-----------------|
| ENH: Add Point/Cell mouse hover to the visualization view. (#482) | 6146b307 |
| ENH: Pipeline Filter View Shortcuts (#474) | 363e1a14 |
| ENH: Visualization Tree View enhancements (#479) | cc86653b |
| BUG: Use a consistent algorithm to form an absolute path. (#466) | 43a8a834 |
| BUG: Fix issue with QtADS on Linux QWayland Windowing Systems (#480) | aa98c568 |
| ENH: Add render window context menu option to show/hide all representations in the window (#477) | 4d4445d9 |
| ENH: Save visualization core object pipeline output to vtk file (#476) | d1404379 |
| BUG: load visualization file issues (#475) | e0ff150b |
| ENH: Update parent VXFilter visibility when representation visibility changes (#471) | 82ad8369 |
| BUG: Copy Qt6 Wayland support directories into the deployed package (#470) | 8cb559da |
| BUG: Fix several nullptr crashes. | 86c547b8 |
| BUG: Do not try to load SSL certificates | cebf7f22 |
| COMP: Fix compile error when building with python | 1f5b1f00 |
| ENH: ImportCSVData now automatically sets starting line based on header line. | 09f5ef50 |
| CSS: Update CSV Import Wizard for better visibility in dark mode. | 846aabce |
| COMP: Fix some compiler warnings about enumeration values not being used. | 6b3261d4 |
| Completely disable any network capabilities with DREAM3D_ENABLE_TELEMETRY=OFF | bb140975 |
| BUG: Fix crash in Volume and Slice Representations. | 98c8b7af |
| ENH: ImportCSV Allow user to set num preview lines. Update preview table properly | e7f8de7c |
| BUG: Fix Camera Parallel Projection feature not working | 37eed311 |
| BUG: Fix blank rows in DataSetInfoWidget Table when re-running a pipeline | 9510d8df |
| BUG: Fix issue when thresholding a multicomponent array, only used comp[0] | ca8ad1a4 |
| BUILD: Correctly place the Data folder into the DREAM3DNXData folder. | 56f66a49 |
| BUILD: Update to Qt6.5.2 for Azure builds | 75ab5412 |
| Pinned and workflow parameters are now hidden by default. | ceacfb63 |
| Light Theme: Fixing white and black text color because they were swapped. | 0111f9ac |
| ENH: Brand new VTK rendering backend codes (#448) | 1d4ca314 |
| Release: Merge 7.0.0-RC5 Changes(#459) | c48fb22d |

### simplnx

| Description | Git Commit Hash |
|-------------|-----------------|
| BUG/PERF: Find Neighborhoods Progress and Parallel Optimizations (#697) | f77af9cb |
| BUG: Fix human name for FeatureFaceCurvatureFilter (#695) | f5e49253 |
| BUG: Disable parallel for Find Neighborhoods and Fix Copy Error In Fill Bad Data (#694) | 43961a94 |
| CONDA: Various fixes to allow packaging of python bindings. (#691) | 0fe5cfc3 |
| ENH: Add More Resampling Modes To Resample Image Geometry (#689) | 7916a565 |
| Filter: SurfaceNets Surface Meshing Implementation (#619) | 14839f31 |
| ENH: Improve the Tuple Count validation error reporting (#684) | b4998681 |
| ENH: Python binding documentation and autogeneration (#673) | ae64af7f |
| TEST: Update PartitionGeometry Unit test to use Catch2 GENERATOR sections (#666) | af35eb3b |
| ENH: Calculate "Modal Histogram Bin Ranges" Array In Find Attribute Array Statistics (#686) | 55fc837c |
| ENH: Changed STLFileReader filter to allow user setting of FaceNormals. (#680) | e51d69f0 |
| FILTER: Import Fiji Montage (#667) | b8a3d45f |
| BUG FIX: InitializeData now initializes the entire Z range. (#683) | bf425098 |
| FILTER: Add Feature Face Curvature (#681) | b6a2fc8c |
| ENH: Calculate "Most Populated Bin" Array In Find Attribute Array Statistics (#679) | 4fc83e65 |
| BUG: Fixed stack-use-after-scope ASAN error (#682) | 58ab5153 |
| BUG: Fix failing ASAN tests (#675) | a85bfd39 |
| ENH: Import the Material Names when importing H5EBSD Files, Include IPFLegends, Error out on Hex grid .ang files (#674) | cb2a5b1c |
| Updating FindArrayStatistics to find mode(s) in the input data. (#677) | b2ed71b0 |
| BUG FIX: NeighborList now creates new lists when resized to a larger size. (#676) | a15dfec1 |
| ENH:MultiThresholdObjects: Add ability to set custom TRUE and FALSE values. (#669) | b65210cf |
| PYTHON: Update python bindings to include recipes for anaconda distributions (#672) | 762d9899 |
| API: Add C++ Class Name to All Default Tags (#671) | 793711d1 |
| API/FILTER: Added INL Writer and Simplnx Versioning Updates (#668) | 106dc04a |
| Tweak filter human labels to remove version number string. (#670) | ad029a98 |
