```{index} triple: DREAM3D-NX; Release Notes; 7.0.0-rc7
```

# 7.0.0-Release Candidate 7

This is the 7.0.0 Release Candidate 7. Below are listed the many bug fixes and development that have gone into this release.

## New Features

+ Save the complete state of the visualization windows so that you can recreate them easily later on
+ Set default visualization options that will be used when visualizing the data from the end of a pipeline run
+ Cell/Point mouse data highlighting is much faster now.
+ Added an Expand/Collapse all in the Render Properties tree view
+ You can create a Multi-Threshold Objects filter from the visualization mode.
+ Data Arrays that are, or could be, modified by a filter are now marked in the DataStructure View with a "delta" symbol.
+ Additional Visualization annotation options: Corner, free float and image.
+ Rename visualization tree view items.
+ Numerous bug fixes and enhancements to the underlying filters.

### Filter Renaming

In an effort to be consistent with filter nameing, a number of input and output filters have been renamed.

#### Simplnx Core

| Old File Name | New File Name | Type |
|----------|----------|-----------|
| AbaqusHexahedronWriterFilter | WriteAbaqusHexahedronFilter | Filter |
| AbaqusHexahedronWriter | WriteAbaqusHexahedron | Algorithm |
| AvizoRectilinearCoordinateWriterFilter | WriteAvizoRectilinearCoordinateFilter | Filter |
| AvizoRectilinearCoordinateWriter | WriteAvizoRectilinearCoordinate | Algorithm |
| AvizoUniformCoordinateWriterFilter | WriteAvizoUniformCoordinateFilter | Filter |
| AvizoUniformCoordinateWriter | WriteAvizoUniformCoordinate | Algorithm |
| ExportDREAM3DFilter | WriteDREAM3DFilter | Filter |
| FeatureDataCSVWriterFilter | WriteFeatureDataCSVFilter | Filter |
| ImportDeformKeyFileV12Filter | ReadDeformKeyFileV12Filter | Filter |
| ImportDeformKeyFileV12 | ReadDeformKeyFileV12 | Algorithm |
| ImportVolumeGraphicsFileFilter | ReadVolumeGraphicsFileFilter | Filter |
| ImportVolumeGraphicsFile | ReadVolumeGraphicsFile | Algorithm |
| ImportBinaryCTNorthstarFilter | ReadBinaryCTNorthstarFilter | Filter |
| ImportBinaryCTNorthstar | ReadBinaryCTNorthstar | Algorithm |
| LosAlamosFFTWriterFilter | WriteLosAlamosFFTFilter | Filter |
| LosAlamosFFTWriter | WriteLosAlamosFFT | Algorithm |
| RawBinaryReaderFilter | ReadRawBinaryFilter | Filter |
| RawBinaryReader | ReadRawBinary | Algorithm |
| StlFileReaderFilter | ReadStlFileFilter | Filter |
| StlFileReader | ReadStlFile | Algorithm |
| VtkRectilinearGridWriterFilter | WriteVtkRectilinearGridFilter | Filter |
| VtkRectilinearGridWriter | WriteVtkRectilinearGrid | Algorithm |
​

#### OrientationAnalysis

​
| Old File Name | New File Name | Type |
|----------|----------|-----------|
| EnsembleInfoReaderFilter | ReadEnsembleInfoFilter | Filter |
| EnsembleInfoReader | ReadEnsembleInfo | Algorithm |
| ExportGBCDGMTFileFilter | WriteGBCDGMTFileFilter | Filter |
| ExportGBCDGMTFile | WriteGBCDGMTFile | Algorithm |
| ExportGBCDTriangleDataFilter | WriteGBCDTriangleDataFilter | Filter |
| ExportGBCDTriangleData | WriteGBCDTriangleData | Algorithm |
| ImportH5Data | ReadH5Data | Utility |
| ImportH5EspritDataFilter | ReadH5EspritDataFilter | Filter |
| ImportH5EspritData | ReadH5EspritData | Algorithm |
| ImportH5OimDataFilter | ReadH5OimDataFilter | Filter |
| ImportH5OimData | ReadH5OimData | Algorithm |
| INLWriterFilter | WriteINLFileFilter | Filter |
| INLWriter | WriteINLFile | Algorithm |

## Known Issues

+ The coloring on visualizations may change if multiple split windows are used.

## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D NX

| Description | Git Commit Hash |
|-------------|-----------------|
| ENH: copy data path selection button/list (#533) | 83083dfa |
| ENH: visualization custom range options (#530) | f72f02be |
| ENH: Visualization presets & persistent settings (#522) | a4aeb95c |
| BUG: Disable renaming bookmarks to an empty string (#535) | a61fba5d |
| BUG: Fixed issues in the NX version UpdateCheck methods. (#524) | b18c9832 |
| API: H5EbsdReaderParameter API Changes (#532) | 338d16fc |
| BUG: Fix various visualization initialization bugs (#526) | 9aaafae7 |
| NEH: Updated UI changes for new simplnx Out-of-Core functionality (#495) | e34580d2 |
| ENH: Misc adjustments to the visualization window (#513) | e89451b1 |
| ENH: Quiet sphinx-build by redirecting output to log file (#521) | 606258c7 |
| ENH/BUG: Update cell hover highlighter  (#512) | fb310fbe |
| ENH: Updates for checking for unsaved pipeline data (#518) | 3f8e396e |
| ENH: Visualization treeview expand/collapse all (#516) | 722d23ec |
| ENH: Visualization active window styling updates (#519) | 5426e893 |
| ENH: Create Multi-Threshold Objects filter from VXFThresholds filter (#517) | d00ea0be |
| QT: Update Linux build bots to Qt 6.5.3 (#520) | 480556b4 |
| Fix bug where filtering gets cleared after data structure update (#515) | ba4e28e6 |
| DOC: Update Visualization Documentation (#514) | 564ba4f9 |
| BUG: Read CSV File column data type combo box now updates properly. (#511) | b13e3d7b |
| ENH: Show in the DataStructureTreeView DataObjects that are modified by a filter (#496) | 2990af16 |
| BUG: ReadCSVFileWidget - Use IndexToDataType to find the correct DataType match. (#507) | b137e54d |
| BUG : Fix lookup table issues which caused the data range of arrays to display improperly (#508) | 54dccde0 |
| ENH: Save/Load Visualization State & remove rep duplicates on split view (#497) | db07307c |
| AZURE: Use CDash scripts on Azure to report failures during CI testing (#505) | d564aa5a |
| AZURE: Correctly report errors during configure, build, test or package (#504) | 4e501e48 |
| CMAKE: Only overwrite generated header if the content is different. | 7d95f8bf |
| BUG: Fix crash when cutting multiple filters at once (#501) | 026a97ca |
| DOC: Update the developer documentation to spinning up a new dev environment | af852c7b |
| BUG: Fix missing Orientation Utility | 35de67e9 |
| BUG: Fix package generation with multi-config cmake generators (#499) | 8a27c82d |
| DOC: Use Sphinx to build documentation. ReStructured Text format for main D3D docs (#478) | cc7b0b08 |
| ENH: Rewrite Import CSV File User Interface (#498) | 3e041a55 |
| ENH: Visualization file reload (#490) | c2ec9a4e |
| BUG: OEMH5EbsdParameter updates (#485) | 20fe130d |
| ENH: Additional annotation options (#493) | 867cf1c2 |
| Remove dependency on EbsdLib for the NX Parameter. | fec1c63e |
| ENH: Remove superfluous print statements to the output window (#494) | 90217f68 |
| Fix "function not marked override" warning. | f28403a7 |
| ENH: Add ability to rename visualization tree items (#486) | 1ff5f12e |
| ASAN: Fix use-after-free issues in some parameter widgets. (#491) | 6c492e37 |
| BUG/ENH : point cell hover fixes & updates (#483) | 371c7e3d |
| QtADS: Update to latest commits | ab2945ac |
| VERS: Update to RC-7 Version tags | 5af7e8c6 |
| ENH: Update the global data axes grid anytime a representation's visibility changes (#484) | 6f3832d9 |
| REL: 7.0.0-RC6 (#481) | 896fe7d4 |

### simplnx

| Description | Git Commit Hash |
|-------------|-----------------|
| PYTHON: Add DataStructure and DataPath APIs  (#740) | 12ef18ca |
| BUG: Fix validation logic in ValidateNumFeaturesInArray (#768) | 956098cd |
| BUG: ApplyTransformationToGeometry-Add option for no interpolation. (#766) | 2704410a |
| ENH: Consistent use of "Numeric Type" in human labels. (#767) | 573cb844 |
| API: Standardize I/O Naming to Read/Write (#753) | 8b7b55d7 |
| BUG: VTK Rectilinear Grid Writer Bufferring (#765) | 461f0a24 |
| ENH: Enable Out-of-Core functionality (#703) | 63c80dc3 |
| ENH: If a test data file is downloaded, then print the bandwidth in bytes/sec (#762) | 202f73f0 |
| ENH: Quiet sphinx-build output by redirecting to log file (#761) | 3ac47576 |
| PY: Python bindings 1.1.0 Release (#758) | 67523f38 |
| BUG: ExtractVertexGeometry - Fix crashes/bugs in the filter. (#757) | dd9d23f3 |
| BUG: Export ASCII Data now exports multiple arrays correctly. (#756) | 7d13d2fd |
| ENH: Use "Mask" instead of "GoodVoxels" consistently for human facing strings. (#755) | 816d3755 |
| PY: Use SPHINX_BUILD_EXECUTABLE instead of SPHINX_EXECUTABLE (#750) | c4e5572e |
| ENH: Additions to nxrunner for detailed version information. (#752) | 90ec76aa |
| ENH: Add HumanStringToDataType Method in TypesUtilities.h (#754) | 895efff6 |
| ENH: Create DataModifiedAction that marks DataObjects as being modified by a filter (#735) | 00e3ef1b |
| ENH: Added 4 Major Issue Templates (#749) | 6d16f20f |
| API: Added cx.DataPath constructor to take a "/Path/Like/This" string (#751) | 867a59fb |
| ENH: Standardize and Cache Random Seed values used in filters  (#745) | f185948d |
| ENH: GenerateColorTable allows use of a mask array. (#747) | e8b0ae21 |
| ENH: Convert AttributeArray DataType allows user to delete input array. (#746) | ae787bc5 |
| TEST: Add Unit test for empty Help Strings in filters. Clean up empty help strings (#744) | 1807f623 |
| DOC: Add Yang Liu as a Contributor for Research and Data (#743) | 5894c81c |
| DOC: Improve explanations for the Find Average C-Axis algorithm. (#741) | c7fb7523 |
| FILTER: EDAX .ang file Hex Grid To Sqaure Grid Converter (#738) | 8ba8129a |
| ENH: Replaced CMAKE_CFG_INTDIR with $<CONFIG> (#687) | 677ddc67 |
| DOC: Update documentation files to allow Sphinx to generate html documentation (#708) | 0f7c2340 |
| BUG: Normalize Final Find Avg C Axes Direction Vector (#739) | 8ff5e44e |
| ENH: Read CSV File Filter Redesign (#706) | 583b0730 |
| DOCS: Update to the python docs. (#733) | 6b26206e |
| ENH: Add proper sample and crystal reference frame rotations to these pipelines (#734) | 8ffc4354 |
| REQ: Update EbsdLib Requirement to v1.0.26 (#711) | 7f66507e |
| DOC: Small documentation fixes. (#732) | 287b427e |
| DOC: Add VKUDRI as a Contributor for Code (#727) | 36f1229e |
| DOC: Add john-stone-ics as a Contributor for Code (#726) | e77b6203 |
| DOC: Add bpenniebq as a Contributor for Code (#725) | eda1952f |
| Docs: Add nyoungbq as a Contributor for Code (#724) | 26fac995 |
| DOC: Add mmarineBlueQuartz as a Contributor for Code (#723) | f4a50a67 |
| DOC: Add jmarquisbq as a Contributor for Code (#722) | fc97abf2 |
| DOC: Add joeykleingers as a Contributor for Code (#721) | b5bc6b00 |
| DOC: Add JDuffeyBQ as a Contributor for Code (#720) | 89632298 |
| Docs: Add imikejackson as a Contributor for Code (#718) | 853898cb |
| BUG: Update .all-contributorsrc (#713) | 3c5c4fc4 |
| DOC/ENH: Contributor Updates (#712) | d114bc30 |
| COMP: Fix compiler warnings due to casting. (#709) | 693c04c0 |
| ENH: Remove dependency on EbsdLib for the Parameter. (#702) | 65a500f2 |
| DOC: Fill in missing ITK Filter help text. Improves generated python documentation (#707) | d61e79c9 |
| BUG: ITK Filters should check total number of tuples for input compatibility (#705) | aa3a8432 |
| BUG: STLFileReader/Writer - Fix crash when reading certain kinds of STL Files. Fix output path when writing (#701) | 42bd7f10 |
