```{index} triple: DREAM3D-NX; Release Notes; 7.0.0-rc9
```

# 7.0.0-Release Candidate 9

This is the 7.0.0 Release Candidate 9. Below are listed the many bug fixes and development that have gone into this release.

## Known Issues

- Long visualization operations can lock up the GUI. Please be patient for those operations to end.

## New Features

- Visualization: 2D Image/Slice view (MUCH faster to view rendered data)
- Visualization: Allow the Visualization Properties tree to be filtered and sorted.
- Add a Table View for data
- Allow user to dock/undock *any* UI widget.
- Filter: Lable CAD Geometry
- Filter: Remove Flag Triangles
- Enhancement: ITKImageReader allows user to set the origin and/or spacing
- Enhancement: ITKImageStackReader allows the user to convert images to grayscale on the fly
- Enhancement: STL File writer can write entire triangle geometry in a single STL File
- Enhancement: Crop Image Geometry with Physical Coordinate Bounds

## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the
start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D NX

| Description (author) | Git Commit Date |
|----------------------|-----------------|
| DOC: Update RC9 release notes [mike.jackson] | e086c0cf |
| ENH: Read CSV Filter Parameter improvements (#596) [mike.jackson] | 21cea829 |
| ENH : Ignore duplicate VTK render calls. (#594) [jessica.marquis] | 42ee1828 |
| ENH: Visual updates and bug fixes (#590) [jessica.marquis] | eadb6a08 |
| PY: Fixed prebuilt pipeline installation issue when packaging for Anaconda (#592) [jared.duffey] | e8ad2641 |
| ENH: Add filtering & sorting to visualization render window treeview (#578) [jessica.marquis] | 326b7fd4 |
| Fix memory leak with data set from VXDataSource & the original index arrays (#591) [jessica.marquis] | 9209a64e |
| ENH: ImageGeom Origin and Spacing clearly identified in mouse hover info [mike.jackson] | 654366d2 |
| ENH: Add tool tips for pipeline filter list item "buttons" (#589) [jessica.marquis] | d6ffe86b |
| BUG: Try...Catch for azure variables that are not defined for develop builds [mike.jackson] | 9e9d86fb |
| BUG: Fix crashing bug when duplicating filter to the end of pipeline (#587) [jessica.marquis] | c78bcdff |
| ENH: Improve Buttons that control camera snapping in the 3D widget (#575) [jessica.marquis] | dbb208e3 |
| PY: Package DREAM3D-NX as an Anaconda installable package (#579) [mike.jackson] | 8ff6fa32 |
| BUG/ENH : Fix issues in the Volume Data View (#585) [jessica.marquis] | 7e1d8ceb |
| BUG : Do not allow a filter to be removed from the pipeline by dragging outside the pipeline (#586) [jessica.marquis] | a1d524eb |
| ENH : Add new Image Data View (#573) [jessica.marquis] | 8aceefbc |
| Add ability to delete visualization presets (#574) [jessica.marquis] | 4299a819 |
| Fix data structure hover info for image geometries to match what is actually stored (#576) [jessica.marquis] | c28224ff |
| Add versioning to settings file in order to better initialize the filter parameters, workflow parameters, and visualization dockwidgets when comming from version 0 (#577) [jessica.marquis] | b4330077 |
| BUG: Fix dynamic table widget not saving user entered value. (#572) [joey.kleingers] | a56c5cca |
| DOC: Cleanup VS Generated Solution file for documentation targets [mike.jackson] | e67ab887 |
| BUG: Fix widget initialization for detach color setting buttons (#571) [jessica.marquis] | 45d33551 |
| ENH: Sphinx generation improvements [mike.jackson] | fe5bc238 |
| Fix nullptr check in global source objects [jessica.marquis] | dde8b69c |
| BUG: Fix warning for nullptr in Qt signal/slot connection. [mike.jackson] | 23773772 |
| BUG: Check nullptr before use in CDockWidget [mike.jackson] | e65e7bed |
| BUG: dock widget bug fixes (#570) [jessica.marquis] | edd99cd8 |
| ENH: no central dock widget (#566) [jessica.marquis] | bb5f0afc |
| BUG: Use correct preference file naming conventions on macOS (#568) [mike.jackson] | 738c52b0 |
| ENH: Cleanup more internal names complex->simplnx (#565) [mike.jackson] | c71ad4e0 |
| ENH: spreadsheet view (#560) [jessica.marquis] | 07cef0bd |
| Set PYTHONHOME using CONDA_PREFIX value when launching DREAM3DNX. (#567) [joey.kleingers] | a4b89c61 |
| BUG: Fix vtk widgets out-of-viewport rendering (#542) [jessica.marquis] | 79dbc3e0 |
| ENH: Rename complex to simplnx (#559) [mike.jackson] | f9f2f5cd |
| DEV: Update to RC-9 versioning (#562) [mike.jackson] | e01491f3 |

### simplnx


| Description (author) | Git Commit Date |
|----------------------|-----------------|
| Description (author) | Git Commit Date |
| ENH: WriteAsciData now writes String Arrays (#856) [mike.jackson] | f36a7320 |
| COMP: Fix VS compiler warnings (#855) [mike.jackson] | a55bf295 |
| DOC: Created example images for most ITK ImageProcessing Filters (#841) [alex.jackson] | c16c9d57 |
| ENH: ReadCSVFilter and TriangleCentroidFilter improvements (#854) [joey.kleingers] | dcdb63e2 |
| ENH: FeatureFaceCurvature Filter Enhancements (#853) [mike.jackson] | b568c7bb |
| DEV: Enable macOS-ARM, remove extra checkout steps (#848) [mike.jackson] | f8099861 |
| BUG: GeneratePoleFigure-Only create RGB when creating the Image Geometry (#827) [mike.jackson] | 3a1e77e8 |
| DOC: Link directly to the discussion page on GitHub. (#847) [mike.jackson] | c83e9f2a |
| ENH: Fixed cmake syntax warning (#850) [jared.duffey] | 4db702a5 |
| ENH: Replaced deprecated exec_program with execute_process (#851) [jared.duffey] | 8f1a2919 |
| FILTERS: Added CalculateHistogram, InterpolateGridData, and CliReader Python filters. (#838) [joey.kleingers] | 4a830573 |
| COMP: Clang v14 -ffp-contract=off compiler option (#849) [mike.jackson] | 9d8379b6 |
| FILTER: Label Triangle Geometry and Remove Flagged Triangles Filters (#842) [nathan.young] | d512fa24 |
| BUG: Fixed example pipeline installation when creating Anaconda package (#846) [jared.duffey] | c265d601 |
| ENH: Misc user facing labels and help text updates (#845) [mike.jackson] | 62e6ecec |
| BUG: Fix IParallelAlgorithm not running in parallel (#844) [mike.jackson] | d1d613b2 |
| BUG: Fix human facing label in Crop Image Geometry (#843) [mike.jackson] | 73a21c9e |
| BUG: ReadStlFile-Fix error logic when reading an ASCII STL File. (#839) [mike.jackson] | 77f3909c |
| Updated vcpkg baseline for pybind11 2.11.1 (#840) [jared.duffey] | 0ff43b9d |
| PY: Fix GIL crashes, unit test false positive results, misc other test issues. (#831) [jared.duffey] | c6112835 |
| ENH: ApplyTransformationToGeometry: Better error messages, Update documentation. (#835) [mike.jackson] | 6406635b |
| ENH: ITKImageReader - Allow user to set/override the origin/spacing (#834) [mike.jackson] | 18498ae2 |
| ENH: ITKImportImageStack - Add option to convert images to grayscale 'on-the-fly'. (#832) [mike.jackson] | 19b009c8 |
| BUG: ITKImportFijiMontage: Fixing incorrect DataPath that was causing a crash. (#833) [joey.kleingers] | 7c434ae5 |
| BUG: Fix preflight updated values for Create Geometry filters (#825) [jessica.marquis] | 7060dcaa |
| BUG: Fix ITKImportImageStack image flip operations. Add unit test for flip operations. (#815) [mike.jackson] | 3f70819a |
| DynamicTableParameter: Return better error message when validation fails. (#824) [joey.kleingers] | 554be1bd |
| FILTER: Generate Python Plugin/Filter Skeleton Code (#821) [joey.kleingers] | f869943b |
| Fixed shallow copy in python bindings function (#822) [jared.duffey] | 3b8230ce |
| Changed StringArray to store its data in a shared_ptr (#823) [jared.duffey] | ce7ae084 |
| ENH: Crop Image Geometry with Physical Coordinate Bounds (#818) [nathan.young] | 3e637324 |
| PY: Added Python Code for Most Example Pipelines (#800) [alex.jackson] | f282e771 |
| ENH: Fix various anaconda packaging issues (#810) [mike.jackson] | 6eef7638 |
| ENH: Group a copy file target into the proper source group (#817) [mike.jackson] | 91964a50 |
| DOC: ConvertHexGridToSquareGrid. Update and add image to doc file (#816) [mike.jackson] | 3fa6c4a1 |
| ENH: Write STL File - Option to write out the entire triangle geometry in a single file. (#809) [nathan.young] | 1e7759ae |
| BUG: Fix determination of default parallelization mode. (#814) [mike.jackson] | 8641d3f4 |
| STYLE: Fix all-contributors Dynamic Badge in README (#813) [nathan.young] | f1d7bbed |
| BUG: Fix missing python dependencies for ASAN build (#812) [mike.jackson] | f36fa0cd |
| ENH/BUG: Additional Origin Centering Options and BoundingBox API Fix (#811) [nathan.young] | 62df7647 |
| Expose IDataArray/IDataStore resize_tuples method to Python. (#807) [joey.kleingers] | 4994adba |
| PY: Fix crash when running nxrunner with python filters. (#808) [mike.jackson] | 26de9937 |
| PY: Enable testing python example codes (#806) [mike.jackson] | cded997f |
| ENH: Create unit tests for each python example pipeline (#793) [mike.jackson] | 0e9ce25e |
| ENH: Add Additional Warnings When Moving/Copying DataObjects with a Tuple Mismatch (#804) [nathan.young] | 6b7b1f0e |
| BUG: Repair Append Image Geometry Z Slice Default Pipeline (#805) [nathan.young] | ca4c8189 |
| ENH: Rename complex to simplnx (#801) [mike.jackson] | 95265d6c |
| BUG FIX: All IDataCreationAction subclasses now correctly pass the geometry path member variable when being cloned. (#802) [joey.kleingers] | f340465e |
| ENH: Write Temp Files for All Writers (#790) [nathan.young] | 5b9d046b |

