```{index} triple: DREAM3D-NX; Release Notes; 7.0.0-a1;
```

# 7.0.0-Alpha 1

## Fixed Issues

- General Fixes
  - Corrected ARGB calculations to use ARGB and not RGBA
  - Rewrote the threshold classes for huge performance gain.
  - Optimized triangle calculation filters
  
- Node Geometries
  - Fixed issue of duplicate updating of the Vertex ID
  - Fixed check when identifying edge point ids for geometries
  - Fixed check when setting edge point ids for geometries
  - Fixed check when identifying/setting face point ids for geometries

- Apply Transformation To Geometry
  - Fixed bug with rotation

- Calculate Feature Sizes
  - Fixed off-by-one bug
  - Fixed bad logic to find the unique set of feature ids

- Calculate Triangle Areas
  - Fixed filter accepting non-Triangle Geometries
  - Updated to be less susceptible to runtime errors

- Conditional Set Value
  - Uses more robust comparisons

- Crop Image Geometry
  - Fixed runtime bugs where the proper data was not being copied
  - Fixed a bug that resulted in improper cropping

- CSV Reader
  - Updated to make read in more robust
  - Updated to make less prone to errors

- Export DREAM3D File
  - Now creates path when its path is nonexistent

- Extract Internal Surfaces From Triangle Geometry
  - Optimized algorithm for speed

- Find Differences Map
  - Update to calculate difference with bigger number first
  - Allow bool arrays

- Find Neighbors
  - Fixed error that results in incorrect output
  - Properly size arrays
  - Fixed logic to find Feature array for initializing new arrays

- Find Minimum Neighbors
  - Fixed several bugs
  - Added speed enhancements

- Find Surface Features
  - Fixed an error that incorrectly labeled surface features with 0
  - Fixed indexing error when calculating surface features for a 2D geometry in the YZ plane

- HDF5
  - Fixed bool converting to uint8 when reading from HDF5
  - Fixed importing a Node Geometry from HDF5 file

- Quick Surface Mesh
  - Fixed bug where geometries were not created properly

- Raw Binary Reader
  - Optimized algorithm to make read in faster

- Remove Minimum Size Features
  - Allow user to set the 'Feature Group' so that all arrays in that group are updated

- Rotate Sample Ref Frame
  - Added option to delete original geometry

- Scalar Segment Features
  - Redesigned algorithm for large performance gain

- STL File Reader
  - Add the option to scale output after reading


## Known Issues

- Widget Docking bug on Ubuntu 22.04 LTS + Wayland

- Rotate Sample Ref Frame
  - Doesn't support NeighborLists and StringArrays

- DataStructure
  - makePath function could have possible undefined behavior in fringe cases

- DREAM3D limited backwards compatibility

- Some filters are missing progress updates

Not all filters are present for this release. 130 of 400 filters are ported. Notably absent are the synthetic building filters , i.e., StatsGenerator. Old Pipelines do ***NOT*** work with this version as the format has changed. Old DREAM3D files ***CAN*** be opened and used in this version of DREAM3D. **Undo/Redo commands are absent.** This is a release candidate so expect there to be some stability issues. Please report any issues [here](https://github.com/BlueQuartzSoftware/DREAM3DNX-Issues/discussions/issues).

## For Code Contributors

***For those that wish to contribute, it is highly recommended that they review the pull_request_template.md, Code_Style_Guide.md, Porting_Filters.md files in the [simplnx repository](https://github.com/bluequartzsoftware/simplnx) before contributing.***

## Added Filters (7.0.0-Alpha 1)

- AlignGeometries
- AlignSectionsFeatureCentroid
- AlignSectionsList
- AlignSectionsMisorientation
- ApplyTransformationToGeometry
- ApproximatePointCloudHull
- ArrayCalculator
- BadDataNeighborOrientationCheck
- CalculateArrayHistogram
- ChangeAngleRepresentation
- CombineAttributeArrays
- ConditionalSetValue
- ConvertColorToGrayScale
- ConvertDataArrayType
- ConvertOrientations
- CopyDataGroup
- CopyFeatureArrayToElementArray
- CopyObject
- CreateArrayofIndices
- CreateAttributeMatrix
- CreateDataArray
- CreateDataContainer
- CreateElementArrayFromFeatureArray
- CreateEnsembleInfo
- CreateFeatureArrayFromElementArray
- CreateGeometry
- CreateImageGeometry
- CropImageGeometry
- CropVertexGeometry
- DataContainerReader
- DataContainerWriter
- DeleteData
- DynamicTableExample
- EbsdSegmentFeatures
- EbsdToH5Ebsd
- ErodeDilateBadData
- Error/WarningTestFilter
- ExampleFilter1
- ExampleFilter2
- ExecuteProcess
- ExtractAttributeArraysFromGeometry
- ExtractComponentAsArray
- ExtractInternalSurfacesFromTriangleGeometry
- ExtractVertexGeometry
- FeatureDataCSVWriter
- FillBadData
- FindAttributeArrayStatistics
- FindAvgOrientations
- FindAvgScalarValueForFeatures
- FindDifferenceMap
- FindEuclideanDistMap
- FindFeatureCentroids
- FindFeaturePhases
- FindFeatureReferenceMisorientations
- FindFeatureShapes
- FindGBCD
- FindKernelAvgMisorientations
- FindMisorientations
- FindNeighborhoods
- FindNeighborListStatistics
- FindNeighbors
- FindNumFeatures
- FindSchmids
- FindShapes
- FindSizes
- FindSurfaceAreaToVolume
- FindSurfaceFeatures
- FindTriangleGeomCentroids
- FindTriangleGeomShapes
- FindTriangleGeomSizes
- FindVertexToTriangleDistances
- FindVolFractions
- GBCDTriangleDumper
- GenerateFaceIPFColoring
- GenerateFaceMisorientationColoring
- GenerateFZQuaternions
- GenerateIPFColors
- IdentifySample
- ImportASCIIDataArray
- ImportHDF5Dataset
- InterpolatePointCloudToRegularGrid
- IterativeClosestPoint
- ITKAbsImageFilter
- ITKACosImageFilter
- ITKAdaptiveHistogramEqualizationImageFilter
- ITKATanImageFilter
- ITKBinaryContourImageFilter
- ITKBinaryThresholdImage
- ITKClosingByReconstructionImageFilter
- ITKCosImageFilter
- ITKGradientMagnitudeImage
- ITKGrayscaleFillholeImage
- ITKImageReader
- ITKImageWriter
- ITKImportImageStack
- ITKInvertIntensityImageFilter
- ITKLog10ImageFilter
- ITKLogImageFilter
- ITKMaskImage
- ITKMedianImageFilter
- ITKMorphologicalWatershedImageFilter
- ITKNormalizeImage
- ITKOpeningByReconstructionImageFilter
- ITKOtsuMultipleThresholdsImageFilter
- ITKSignedMaurerDistanceMapImageFilter
- ITKSinImageFilter
- ITKSqrtImageFilter
- ITKTanImageFilter
- LaplacianSmoothing
- MapPointCloudToRegularGrid
- MergeTwins
- MinNeighbors
- MinSize
- MultiThresholdObjects
- MultiThresholdObjects2
- NeighborOrientationCorrelation
- PartitionGeometry
- PipelineAnnotation
- PointSampleTriangleGeometry
- QuickSurfaceMesh
- RawBinaryReader
- ReadAngData
- ReadASCIIData
- ReadCtfData
- ReadDream3DFile
- ReadH5Ebsd
- ReadStlFile
- RemoveFlaggedFeatures
- RemoveArrays
- RemoveComponentFromArray
- RemoveFlaggedFeatures
- RemoveFlaggedVertices
- RenameAttributeArray
- RenameDataContainer
- ReplaceValueInArray
- ResampleImageGeom
- RobustAutomaticThreshold
- RotateEulerRefFrame
- RotateSampleRefFrame
- ScalarSegmentFeatures
- SetOriginResolutionImageGeom
- SharedFeatureFaceFilter
- SplitAttributeArray
- Stereographic3D
- TriangleAreaFilter
- TriangleCentroidFilter
- TriangleDihedralAngleFilter
- TriangleNormalFilter
- VisualizeGBCDGMT
- VisualizeGBCDPoleFigure
- WriteASCIIData
- WriteBinaryDataFilter
