```{index} triple: DREAM3D-NX; Release Notes; 7.0.0-a2
```

# 7.0.0-Alpha 2

This is the 7.0.0 Alpha 2 Release. Below are listed the many bug fixes and development that have gone into this release.

## Fixed Issues


### DREAM3D NX

| Commit Subject | Git Hash |
|--|--|
| BUG: macos relative paths do not work under a deployed version (#324) | 9282c070 |
| CMAKE: We are going to inject the necessary sources into `simplnx` itself (#342) | 2eae97bb |
| ENH: File Input Path Auto Complete (#350) | 81a769e5 |
| ENH: serialize display settings (#347) | 8df57eaf |
| BUG: Add example pipelines to the unit tests (#340) | 9b017eb9 |
| STYLE: Fix style of QPushButton to match closer to Figma designs (#348) | d9054fd5 |
| Add label to the visualization preferences button (#335) | 5a7961af |
| Update temp pipeline check logic (#349) | 32d0e39b |
| Updated HDF5 filepath and namespace (#333) | f07bf3f9 |
| BUG: Fix crash when reloading data into the Visualization view (#341) | 50e31ae6 |
| BUG: Remove example pipeline test that do not exist any more (#345) | 6867227e |
| BUG: Fix precision when checking locale format in table model (#331) | 49dea4a4 |
| ENH: Move CMake code to download/copy/install data files into their plugins (#323) | d1c39210 |
| Update QtAdvancedDocking to fix Ubuntu Wayland bugs (#326) | 57cf7307 |
| BUG: Fix QSlider issues on macOS 12 and above (#327) | 78aae165 |
| STYLE: Updated and Optimized styling for Pinned and Workflow Buttons (#328) | 51aa967c |
| BUG: Fix issue where all arrays would be read from the source data file (#329) | 1d078716 |
| ENH: Move example pipelines to their respective plugin (#332) | d2d815eb |
| CMAKE: Consistent naming of Folder/File copy targets | 74a77d7d |
| ENH: Reload Visualized Pipeline Results (#317) | 483080e7 |
| ENH: Update link cameras feature to allow linking more than 2 at a time (#320) | d08d674d |
| ENH: Select the first filter when opening a new pipeline (#319) | 47783974 |
| CMAKE: Make build option variables consistent in naming (#315) | 1b29b632 |
| BUG: Only show telemetry preferences  popup if tracking is turned on (#321) | 721f3323 |
| Convert relative paths into absolute paths using the DREAM3DData directory on macOS | 1359030f |
| VERSION: Update version to 7.0.0-Alpha-2 | 52bdbcd8 |


## simplnx_plugins

| Commit Subject | Git Hash |
|--|--|
| Fix Data install rules | 84fd305f |
| Add example pipelines to the unit tests (#105) | 53a62331 |
| ENH: Inject additional Parameter code into the 'simplnx' target library (#107) | 4c531717 |
| Updated HDF5 filepath and namespace (#111) | c0be93be |
| Filter: Move RemoveFlaggedFeatures to SimplnxCore (#106) | b6c12b19 |
| DOC: Display Reference Frame Details in ReadH5Ebsd Filter (#108) | 22417114 |
| FILTER: Move find neighborhoods to simplnx/SimplnxCore (#109) | 428a7c11 |
| ENH: Remove 32bit check for H5EbsdParameter (#110) | becac484 |
| ENH: Add code to download test files that are needed. (#99) | 7639dbe1 |
| BUG: Fix issue when only reading some arrays from ANG data file (#100) | 5afc62cf |
| ENH: Adding more tags to the EBSD data file import filters (#101) | 5800cc8a |
| ENH: Put pipelines with the plugin that they depend on. (#102) | 8c0c798a |
| FILTER: EnsembleInfoReader (#98) | c2a5a187 |
| ENH: Option to ITKImportImageStack to flip each image along the X or Y Axis (#91) | f6b91318 |

## simplnx

| Commit Subject | Git Hash |
|--|--|
| ENH: Use downloaded files, remove test files not needed (#485) | fb62cfc6 |
| Filter: ApplyTransformationToGeometry Porting and Updates (#469) | 36dafe2c |
| BUG: Each operating system has a set preferred preference directory (#484) | a50c5dab |
| BUG: Add example pipelines to the unit tests (#472) | 4fa2530e |
| ENH: Make Create Data Array More User Friendly (#477) | dc262f61 |
| FILTER: Find Vertex to Triangle Distances (#427) | 525d8371 |
| FILTER: ComputeMomentInvariants2D (#471) | 6850c5f8 |
| ENH: Improve FindArrayStatistics memory usage in lieu of compute time efficiency (#475) | 42cd6d40 |
| Feature: Plugin defined Out-of-Core Data Storage (#421) | 6adbb414 |
| FILTER: ExtractFlaggedFeatures RemoveFlaggedFeatures (#474) | d1c35693 |
| ENH: Find Feature Sizes Parameter Clarification (#476) | fb3e925c |
| ENH: Add the ability to set geometry length units (#478) | 6ce73945 |
| FILTER: Find Neighborhoods moved from Core to SimplnxCore (#479) | 59707e32 |
| ENH: Adjust some filter parameters for better usability (#466) | 743359f4 |
| ENH: Organize the example pipelines. (#470) | 74a9dabe |
| Add convenience fct to BaseGroup for getting all Geometry GroupTypes (#465) | 18251ccf |
| FILTER : FindBiasedFeatures (#462) | d0c4524a |

## Known Issues

- Rotate Sample Ref Frame
  - Doesn't support NeighborLists and StringArrays

- DataStructure
  - makePath function could have possible undefined behavior in fringe cases

- DREAM3D limited backwards compatibility

- Some filters are missing progress updates

Not all filters are present for this release. 155 of 400 filters are ported. Notably absent are the synthetic building filters , i.e., StatsGenerator. Old Pipelines do ***NOT*** work with this version as the format has changed. Old DREAM3D files ***CAN*** be opened and used in this version of DREAM3D. **Undo/Redo commands are absent.** This is a release candidate so expect there to be some stability issues. Please report any issues [here](https://github.com/BlueQuartzSoftware/DREAM3DNX-Issues/discussions/issues).

---

## For Code Contributors

***For those that wish to contribute, it is highly recommended that they review the pull_request_template.md, Code_Style_Guide.md, Porting_Filters.md files in the [simplnx repository](https://github.com/bluequartzsoftware/simplnx) before contributing.***

