```{index} triple: DREAM3D-NX; Release Notes; 7.0.1
```

# 7.0.1

This is the 7.0.1 release. Below are listed the many bug fixes and development that have gone into this release.

## Known Issues

- The "Compute Feature Shapes from Triangle Geometry" has been disabled due to bugs in the algorithm
- Long visualization operations can lock up the GUI. Please be patient for those operations to end.
- Synthetic Building Filters are not yet implemented

## Feature & Bug Fixes of Note

- Adds the ability to read Oxford Channel 5 Binary files (.cpr/.crc file pairs)
- Fixes the ability to select files in several parameter widgets including Import HDF5 and several of the HDF5 OEM Ebsd parameters
- Larger parameters now do a better job of using available user interface layout space when available.
- Fixes possible crash when writing DREAM3D files with the XDMF file when node based geometries are empty


## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the
start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D-NX

- ENH: Add better support for large combo boxes (#763) [c38883a9]
- DOC: Fix doc generation errors. Add error message for plugin docs (#772) [140c4db3]
- BUG: Fixes 3D Vis screenshots when using a transparent background (#771) [8270524f]
- BUG: Fix cmake issues with NXVtkLib common introduced with Qt 6.8 (#768) [6718c8f7]
- DOC: Fixes missing images for the documentation. (#767) [77ee442b]
- BUG: Fixes crash on startup due to use of system runtime libs (#766) [c5381694]
- ENH/BUG: Improve the categorization of issues in the issues table  (#765) [f7a9bcb1]
- ENH: Update sizing/layout of widgets in parameter lists so that widgets can take up more space when needed (#764) [be55667c]
- BUG: Fixes the ability to compile DREAM3D-NX without EbsdLib. (#759) [9bdcb0db]
- BUG: Fix file selection dialog boxes for several EBSD related parameters (#761) [efbfb8bd]
- BUG: Changes uses of 'suffix' to 'completeSuffix' for file extension extension (#762) [a2410f12]
- COMP: Move Azure pipeline files to a nested folder [3af2dcfe]
- Add missing CMake variable checks to fix compile errors. (#755) [137f69fb]

### SIMPLNX 

- ENH: Refactors the calculation of triangle normals and areas into utility functions (#1142) [093c79f53]
- BUG: Fixes issue where any component shape was allowed for ComputeTriangleGeometrySizes (#1134) [f36ca6c75]
- PYTHON: Expose methods to convert numeric types. (#1133) [b35840327]
- BUG: Various small bug fixes and corrections (#1131) [bae524443]
- BUG: Updated vcpkg baseline to include ITK windows compile fix (#1140) [ace11c0f8]
- BUG: XDMF-Ensure there is something to write before getting references. (#1129) [66f754236]
- REL: Update version to 1.5.0 (#1128) [2024-11-12]
