```{index} triple: DREAM3D-NX; Release Notes; 7.0.3
```

# 7.0.3

This is the 7.0.3 release. Below are listed the bug fixes and feature additions that have gone into this release.

## Known Issues

- Synthetic Building Filters are not yet implemented
- Long visualization operations can lock up the GUI. Please be patient for those operations to end.
- Compute Feature Centroids will not respect periodic boundaries in a model
- The Anaconda version will not save your GUI window layout correctly. The workaround is to create a layout to your liking and save it as a preset.

## Feature & Bug Fixes of Note

This release is primarily a quick bug fix for the following issues

- Orienation Widget was not fully rendered using both the box and the arrows.
- Fixes issue where an unreleased feature's preferences were being written and read which would cause crashes.
- Apply Transformation To Geometry Trilinear Interpolation for Image Geometries now works correctly.
- Read String Data Array filter has been added.

## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the
start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D-NX

- CI: Updates GitHub CI Clang Formatter to use Ubuntu 22.04 (#839) (56fda62e)
- ENH: Make color preset dialog search bar in focus when opening dialog (#837) (1bfd27d4)
- DOC: Bring 2D Charting user manual documentation up to date  (#835) (c6cd5323)
- STYLE: Minor updates to charting components (#836) (1cd1f9b9)
- BUG: Enables code that was previously commented out for debugging. (3b1dd0dd)
- CMAKE: Remove references to Qt5 since that version is not compatible (#832) (eb36d69d)
- CONDA: Fix build errors on Linux when trying to find the X11 include dir (#833) (24ccaf57)
- STYLE: Rename uses of 'Complex' to 'Simplnx' to be consistent with underlying library (#812) (760dfe85)

### SIMPLNX 

- BUG: Fixes bugs with Trilinear Interpolation in Apply Transformation to Geometry (#1220) (f052fcf34)
- FILT: ReadStringDataArray implemented (#1211) (b0fb842a0)
- BUG: Compute Twin Boundaries ASAN Cleanup (#1224) (e2258a45d)
- FILTER: Combine Node Based Geometries (#1210) (076136059)
- ENH: Change usages of 'DREAM.3D' to 'DREAM3D-NX' where appropriate (#1218) (0403f41b7)
- BUG: Fixes missing 'MaterialNames' arrays in the Small IN100 pipelines. (#1213) (65e3944a1)
- Removed unused header in Types.hpp (#1219) (4316aeab3)
- CMAKE: Number the file downloads and log download results to a file (#1212) (700306fb7)
- ENH: Allows users to store the transform matrix from the ApplyTransformationToGeometry (#1216) (8c16ef7ed)
- BUG: A NPE crash due to not checking a DataStore<T> pointer. (#1206) (91b62e342)
- BUG: RenameDataObject - Add Missing Overwrite Check (#1209) (a2101456e)
- FILTER: Find Twin Boundaries (#1193) (833d32097)
