```{index} triple: DREAM3D-NX; Release Notes; 7.2.0
```

# 7.2.0

This is the 7.2.0 release. Below are listed the bug fixes and feature additions that have gone into this release.

## Known Issues

- Synthetic Building Filters are not yet implemented
- Long visualization operations can lock up the GUI. Please be patient for those operations to end.
- Compute Feature Centroids will not respect periodic boundaries in a model
- The Anaconda version will not save your GUI window layout correctly. The workaround is to create a layout to your liking and save it as a preset.
- Computing Volumes from Triangle Features will not work correctly unless all triangle normals are consistent and the surface mesh is watertight.

## Feature & Bug Fixes of Note

- 2D Charting has arrived in DREAM3D-NX. This feature is early on in its life cycle but you can already perform a wide variety 
of plots: Histogram, Bar, Line and Scatter plots.
- Build Plate annotations can now be oriented in any direction.
- Pipeline actions can be undone if you accidentally delete or add a filter.
- New Filters added: Write SPParks Sites File
- Filter Changes: All alignment filters can save the produced shifts to a DataArray.

## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the
start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D-NX

- ENH: Allow custom build plate annotation planes (#848) [2025-03-16]
- BUG: Missing Load State and Save State Menus in DREAM3DApplication class (#850) [2025-03-16]
- BUG: Allow scrolling of filter parameters during pipeline execution (#854) [2025-03-16]
- ENH: Add support for category charts/string labels (#831) [2025-03-14]
- BUG: Fixes crashing issues when cell hovering over 2D Image/Slice view. (#852) [2025-03-14]
- ENH: Add back face culling feature to visualization surface view (#851) [2025-03-12]
- ENH: Add Feature to undo and redo pipeline actions (add/remove) (#807) [2025-03-12]
- BUG: Fix missing 2D Image/Slice View Cell Hover feature. (#849) [2025-03-10]

### SIMPLNX 

- FILT: Rename ComputeMisorientations to ComputeFeatureNeighborMisorientations, Add ComputeMisorientations  [2025-03-21]
- ENH: Updates unit test checks to use SIMPLNX_RESULT_REQUIRE_VALID() (#1248) [2025-03-19]
- CI: Install mono for vcpkg in asan build (#1247) [2025-03-19]
- ENH: Write STL Overflow Functionality (#1244) [2025-03-19]
- COMP: Update EbsdLib to 1.0.37 (#1245) [2025-03-18]
- ENH: Added pipeline relative path support (#1238) [2025-03-18]
- FILT: Adds 'Write SPParks Sites File' (#1242) [2025-03-18]
- ENH/BUG: Alignment Filters Modernization (#1237) [2025-03-13]
- BUG: Removes number of triangles guess from QuickMesh and SurfaceNets filters (#1233) [2025-03-12]
- BUG: Changes the Face Label value to -1 for boundary triangles in SurfaceNets (#1188) [2025-03-11]
- DOC: General code clean up to make parameters consistent and docs consistent (#1232) [2025-03-11]
- Updated to clang 17 for asan workflow (#1231) [2025-03-07]
- CI: Updates GitHub CI Clang Formatter to use Ubuntu 22.04 (#1226) [2025-03-07]