```{index} triple: DREAM3D-NX; Release Notes; 7.0.0-rc13
```

# 7.0.0-Release Candidate 13

This is the 7.0.0 Release Candidate 13. Below are listed the many bug fixes and development that have gone into this release.

## Known Issues

- Long visualization operations can lock up the GUI. Please be patient for those operations to end.
- Synthetic Building Filters are not yet implemented

## New Features (Stand Alone Version)

- Build Plate Annotation
- Visualization outline glow
- Support Tetahedral and Hexahedral geometries in the visualization
- File System Parameter enhancements to track changes to the file

## New Features (Anaconda Version)

- New File Readers: Abaqus (.inp), Ansys (.node & .ele), Gmsh (.msh), Salome (.med), TetGen (.msh) and VTK (.vtu)
- New File Writers: Abaqus (.inp), Ansys (.node & .ele), Gmsh (.msh), Salome (.med), TetGen (.msh) and VTK (.vtu)

## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the
start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D-NX

- BUG: Fix bug when creating visualization presets (#713) [e5be4867]
- BUG: Fixed memory leak issues found when reloading pipelines (#712) [bbca06e3]
- ENH: Adjust grouping of the quick access buttons at bottom of UI. [b070e7c4]
- BUG: Fix incompatibilities in VtkBridge for Out-Of-Core APIs (#708) [c78ecc31]
- PY: Update versions of EbsdLib, expected-lite and nod (#709) [4f2e10e1]
- ENH: Add support for C++ 20 (#704) [7bbde202]
- CI: Update CI Machines to use Qt 6.6.3 and Vtk 9.3.1 (#707) [aa8c3ade]
- ENH: Visualization outline glow highlighting (#691) [286102a8]
- ENH/BUG: Visualization copy/paste options (#696) [e196237f]
- ENH: Circular build plate Annotation (#701) [5052752c]
- ENH: Enable hover cells/points for images larger than 4K x 4K. (#703) [2f2fc743]
- BUG: Cache data from color preset model roles to speed up proxy model searching (#702) [ca17c7fb]
- BUG: Fix ruler tool picking bugs (#700) [b3c29f59]
- Turn on word wrapping for preflight updated value labels [69799094]
- Revert "BUG: Fix rendering of textures larger than 4K x 4K (#694)" [362479e8]
- ENH: Render tetrahedral and hexahedral geometries properly (#695) [b98113f0]
- CI: Update MacOS CI to use Qt 6.6.3 (#697) [c72aee70]
- ENH: Remove unused code from the StyleSheet Editor [378ee3e1]
- BUG: Support visibility in multiple split views for VXGlobalSource objects (#692) [8d1939f2]
- BUG: Add popup warning messages about multi comp array support (#693) [9a7ab54b]
- BUG: Fix rendering of textures larger than 4K x 4K (#694) [1957986d]
- ENH: Disable collapsing the visualization settings widget section [cc3d7c14]
- Updates for compatibility with INodeGeometry1D::findElementsContaintingVert api change (#690) [27e8bcd6]
- ENH/BUG: Updates to ImportHDF5DataSetWidget (#689) [7034d580]
- ENH: Fix Threshold widget QSpacer expansion rules. [e18bf991]
- ENH: Build plate annotation (#687) [e42648ce]
- VER: Update to RC-13 (#688) [880987a3]
- Update Conda version [1a401740]
- Clean up the NX Sphinx documentation generation [e160fadb]
- Various install and conda changes [cf6607cb]
- Documentation updates for RC12 [647df52d]
- Start the release notes [3bbeedd9]

### SIMPLNX 

- ENH: Fix compile warnings in FilterUtilities. Init array in DataStore when resizing (#1026) [d534b18d]
- ENH: Update NXRunner error messages to provide instructions for .json files (#1032) [5aa8dd5f]
- ENH: Combine and Write STL Files - Allow user to select a Part Number Index to use for numbering. (#1024) [24a870f9]
- CI: Fixed python tests on asan CI (#1031) [8eccc1bf]
- CI: Updated nightly ASAN CI to use clang 14 (#1029) [37c3df57]
- CI: Update GitHub CI to newer GCC & Clang versions. (#1028) [f05b3781]
- BUG FIX: PeregrineHDF5Reader file system path and Array Type Fixes (#1025) [0332e709]
- ENH: Allow Crop Image Geometry to only crop a specific dimension (#1021) [c3be139e]
- BUG FIX: Remove Python plugin import error handling. (#1019) [b9d47447]
- BUG: Fix Reading Shift File in AlignSectionsList (#1018) [ed04c3ac]
- ENH: Various ReadPeregrineHDF5File Improvements (#1016) [8346cd36]
- Fixed C++20 issue with template id in constructor starting in gcc 11 (#1015) [c62fa7f8]
- ENH: Update required standard to C++20 (#1004) [31406a49]
- PERF: Inline Keyword and Anonymous Namespace Cleanup (#1013) [639460e9]
- DOC: ConvertHexGridToSquareGrid Doc Updates (#1014) [37e1159a]
- COMP: Fix compiler warnings in ComputeSurfaceFeaturesTest (#1003) [8bc16916]
- BUG: Fix out of core preferences file save bug (#1012) [5f1e159f]
- BUG: KAM messages should only be printed at 1 a second. (#1008) [a6324cac]
- FILTERS: Adding MeshIO reader and writers. (#1009) [74a06a32]
- Remove submodule for geometry creation helper methods. (#1007) [3af3fd55]
- ENH: Add the ability to resample images as they are read in as an image stack. (#1011) [a2aaa4cb]
- ENH: Renaming DataAnalysisToolkit to NXDataAnalysisToolkit. (#1010) [1d9a483a]
- FILTER: Add RemoveFlaggedEdges filter. Update other RemoveFlaggedXXX filters (#986) [d7190167]
- ENH: Include additional geometry examples and tests. (#1006) [365acfd8]
- FILTER: SliceTriangleGeometry & CreateAMScanPaths (#984) [8f241745]
- ENH: More explicit details when a parameter does not validate. (#1005) [34a1c054]
- ENH: Added a benchmark utility executable (#1002) [90feefba]
- ENH: Adjust warning text for 0 step value in InitializeDataArray (#999) [cec98fca]
- BUG: Update geometry find element functions to use static casting (#1000) [d86dbbdc]
- FILTER/ENH: DBSCAN Filter and Clustering Cleanup (#994) [e0d0cf26]
- ENH: Update Python Plugin Generation File Structure (#989) [40512e34]
- BUG: Update node based geometry 'findElementSizes(bool)' family of functions (#991) [baf97023]
- ENH: Reading OEM EBSD HDF5 Files should have better error messages generated (#996) [95f41e7b]
- ENH: Added DataStructure::getDataAsUnsafe functions (#998) [788e0736]
- Update vcpkg baseline for HDF5 1.14.4.3 (#997) [68d0e63f]
- DOCS: Create Python tutorial covering basic usage and filter writing (#925) [07dab90b]
- ENH: Small fixes for DREAM3D-NX RC-12 release (#988) [5592a973]
- ENH: Small fixes for RC-12 release [b7958b48]
