```{index} triple: DREAM3D-NX; Release Notes; 7.0.0-rc8
```

# 7.0.0-Release Candidate 8

This is the 7.0.0 Release Candidate 8. Below are listed the many bug fixes and development that have gone into this release.

These are the new and notable feature additions:

- DREAM3D-NX can now import pipelines from previous versions of DREAM3D. These pipelines will need to have been updated
to the latest pipeline file spec as of verison 6.5.171 or 6.6.x
- There is an option to set your visualization presets that will be used when the pipeline will visualize a data set.
- There is a ruler tool that allows users to measure the distance between 2 points in real units.
- The style of the Parameters area will change depending on the state of the filter
- Fixed a crash when dragging filters in the pipeline
- Fixed slow speed when switching between visualization split views
- Fix bugs in the `simplnx` library
- Implement more flexible options in the "Initialize Data Array" filter.

## Known Issues

- The point/cell hover feature will only highlight a one face of an ImageGeometry voxel. The data is still correct.

## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D NX

| Description | Git Commit Hash |
|-------------|-----------------|
| ENH: Add SIMPL Pipeline conversion UI support (#546) | 05bda10c |
| BUG: Update the global axes grid bounds after reloading the pipeline output (#558) | a6872618 |
| ENH: Add Advanced Visualization Preset Options (#557) | a814ca93 |
| ENH: Add a ruler tool to visualization global source types (#548) | d04b3cac |
| ENH: Update Qt Advanced Docking version (#541) | e09ecc9b |
| DOC: Add a CMakeUserPresets.json file to help build VTK (#552) | f42005a5 |
| DOC: Fix broken links on the <www.dream3d.io> website | 71066523 |
| STYLE: Update title color for central Parameter widget based on state of filter (#543) | 906b6a25 |
| BUG: Fix indexing bug when dragging multiple items where the item selected to drag is the last item (#549) | cd31f314 |
| PERF: Fix slow switching between split views. (#537) | 9b76b4ca |
| Call updateDownstreamGridAxesBounds directly after applying filter instead of through vtk observer to avoid render loop (#540) | 2167a2d5 |
| DEV: Update to RC-8 versioning (#539) | df896bb4 |

### simplnx

| Description | Git Commit Hash |
|-------------|-----------------|
| ENH: Implement SIMPL pipeline conversion (#779) | d11a7a8dd |
| ENH: ITKImportImageStack Flip about X|Y Axis speed optimization (#799) | 2ecb34507 |
| DOC: Detailed descriptions for several filter's parameters (#797) | 693671664 |
| ENH: Allow test data to be downloaded from a different URL. (#789) | 1192311e3 |
| PYTHON: Add API to DataStructure, Document API, add example uses. (#792) | c1bdb5a08 |
| BUG: Ensure Sphinx is installed during the conda build process. (#791) | ab76de704 |
| ENH: Fixes to allow ITKImageProcessing to compile against ITK 5.3.0 (#784) | b43f1dad7 |
| Add create_child_path method to be able to modify DataPaths in Python. (#788) | 87026e508 |
| VCPKG: Add Default registry and add OpenSSL as an option (#776) | 7b1b9573a |
| BUG: ReadEspritDataFile - If spacing is zero, reset to 1.0 (#782) | a0675ea12 |
| BUG: Fix Import Fiji Montage Origin and Grayscale conversions (#777) | 462b70b84 |
| ENH: Update method names to dump a DataStructure hierarchy to text or .dot (#780) | b32d15bd5 |
| ENH: Cleanup warning messages for ReadTextDatArray and CreateDataArray (#781) | 749a340ba |
| FILTER: Initialize Data (Initialize Data Rework) (#769) | a06a6d536 |
| ENH: Updated vcpkg baseline for fmt 10.1.1 (#775) | bcc6bae79 |
| BUG: Fix issue where some plugins were not getting wrapped with Python (#773) | 415439adf |
| BUG: ErodeDilateBadData - Fix initialization of ignored data arrays. (#771) | 0e847aa3d |
