```{index} triple: DREAM3D-NX; Release Notes; 7.0.0
```

# Version 7.0.0

This is the 7.0.0 release. Below are listed the many bug fixes and new features 
that have been added to this release.

## Known Issues

- Long visualization operations can lock up the GUI. Please be patient for those operations to end.
- Synthetic Building Filters are not yet implemented
- The 2D Charting module is still under development and is not included in this release

## New Features (Stand Alone Version)

- The user can now set the color for NaN values
- LineEdits that are disabled have more readable text
- Volume Rendering controls have been updated with a more usable design.
- The .dream3d file specification documentation has been written.
- Add 'Read GrainMapper3D' filter.

## New Features (Anaconda Version)

- All features from the stand-alone are included.


## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the
start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D-NX

- ENH: Improve volume view controls (#751) [5fc485ff]
- DOC: Add DREAM3D File specification to the documentation (#746) [01f4c39e]
- ENH: Make Visualization Preset Options More Discoverable (#747) [ac5350db]
- ENH/BUG: Add option to change NaN color in 3D vis (#744) [1a457fe3]
- BUG: Disable left mouse button actions in 2D interactive mode (#748) [0b2c1444]
- ENH: Remove unnecessary warning messages (#745) [378e4d75]
- PY: Add python path to the Visual Studio Debugger [ca4a4ad7]
- BUG: Remove debugging code [8cc70e47]
- STYLE: Adjust QLineEdit disabled colors (#742) [25f14ab9]
- Add minimum height to CSV Reader's preview window. [36d7f6b5]
- BUG: Fix 2D Charting reload crashes. (#741) [73b91520]
- ENH: Quality of life updates (#740) [0765175a]
- COMP: Update clang format standard to C++20 (#737) [08909b17]
- ENH: Add new macro for turning on/off charting separately from 3D vis (#739) [bb09cffe]
- BUG: Fix charting widget crash from bad NXFilter & NXDataStructureModel pointers (#738) [9769d5c7]
- COMP: Add missing visualization macro checks for charting [3c8d8521]
- ENH: Add basic 2D charting feature (#720) [25bab121]
- VER: Update to RC15 [d752fc44]


### SIMPLNX 

- REL: Update version to 1.5.0 [1c957f746]
- FILT: Add Oxford Channel 5 Binary file reader [725b35617]
- BUG: Now catch std::filesystem exceptions in parameters (#1127) [dade5e9b3]
- DOC: Document the DREAM3D file specification (#1116) [e431b770d]
- API: EbsdLib-1.0.34 update. (#1122) [382861a2f]
- BUG: ReadDEFORMFileFilter-Set SharedQuadList names to proper defaults (#1120) [439c08cf9]
- ENH: Fix 3rd Party .dream3d file import and other compiler warnings & issues (#1108) [79cb89d98]
- LICENSE: Change the distribution license to AGPLv3 (#1119) [9bee9ce17]
- ENH: Compute NeighborList Stats Updates (#1118) [3e23b694f]
- ENH: Map Point Cloud to Regular Grid Filter Modernization (#1109) [5cf455d11]
- BUG: WriteASCIIDataFilter-Fix bug writing multi-component arrays to multiple files (#1114) [21b8e797f]
- ENH: GitHub is removing MacOS-12 Support from their Actions. Update to MacOS-13 (#1115) [3d3667a10]
- ENH: Changes to decrease compile time (#1105) [d11d251c0]
- FILT: Add 'Read GrainMapper3D' filter (#1107) [7b6d091df]
- ENH: ITKImportImageStack Z Axis Resampling and Improvements (#1104) [68703bfc7]
- ENH: Iterative Closest Point Filter Changed to 1 Second Update Scheme (#1106) [cd6c44e5b]
