```{index} triple: DREAM3D-NX; Release Notes; 7.0.2
```

# 7.0.2

This is the 7.0.2 release. Below are listed the many bug fixes and development that have gone into this release.

## Known Issues

- The "Compute Feature Shapes from Triangle Geometry" has been fixed and re-enabled
- Long visualization operations can lock up the GUI. Please be patient for those operations to end.
- Compute Feature Centroids will not respect periodic boundaries in a model
- Synthetic Building Filters are not yet implemented

## Feature & Bug Fixes of Note

- Implement a master state file for DREAM3D-NX (#788)
- Fixes algorithm to compute shape factors from Triangle geometry (#1157)
- Add multi component support to MultiThresholdObjectsFilter (#1184)
- Added a number of ITK Projection Filters (#1162)
- Crop Edge Geometry (#1153)
- Add WriteNodesAndElementsFiles filter

## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the
start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D-NX

- REL: DREAM3D-NX v7.0.2 Release [2025-02-24]
- STYLE: Fix padding on combo boxes (#828) [2025-02-24]
- ENH: Add min/max range sliders to all custom range features (#830) [2025-02-21]
- BUG: Fix filter parameter layout priority on setup (#827) [2025-02-20]
- BUG: Fix bug accessing data structure from dream3d file in charting (#829) [2025-02-20]
- BUG: Fix check for final data structure file (#826) [2025-02-19]
- BUG: Fixes memory leak in the 2D Slice/Image View (#821) [2025-02-17]
- ENH: Add feature to Copy Visualization as an image to the Clipboard (#818) [2025-02-13]
- ENH: Rotate Vis Camera Clockwise/Counterclockwise 90 degrees (#819) [2025-02-13]
- DOC: Update developer docs to build DREAM3D-NX and VTK from scratch (#796) [2025-02-12]
- BUG: Fixes style issue with QComboBox and Qt 6.8. (#816) [2025-02-12]
- ENH: Update Qt-Advanced-Docking-System to 4.4.0 release. (#804) [2025-02-12]
- ENH: Updates to DREAM3D file requirements for saving state files (#814) [2025-02-12]
- ENH: Turn off auto scrolling on filter list (#815) [2025-02-12]
- STYLE: Fix styling for Image Slice View slice number slider/spin box (#813) [2025-02-12]
- BUG: Fixes incorrect file path when drag-and-drop on Linux into NXFSDropLineEdit (#801) [2025-02-12]
- ENH: Update comp combo boxes in charting to use large combo boxes (#808) [2025-02-12]
- BUG: Quiets deprecation warnings for Qt 6.8 and beyond. Also removes unused Qt Macros. (#803) [2025-02-12]
- BUG: Fix displayed filter number label when drag move changes order of filters in pipeline (#809) [2025-02-10]
- BUG: Fix data structure model memory leak in DataStructureTreeView (#799) [2025-02-05]
- BUG: Adds missing Qt TLS libraries to the installed application. (#797) [2025-01-31]
- CI: Fix warning message about not being in a git repository (#795) [2025-01-28]
- Updated array thresholds widgets with multi component support (#793) [2025-01-28]
- ENH: Updates to support Qt 6.8 & vtk 9.4 (#792) [2025-01-22]
- ENH: Implement a master state file for DREAM3D-NX (#788) [2025-01-13]
- ENH: Update 'Bookmark' icon and 'RemoveAll' icon (#789) [2025-01-06]
- BUG/ENH: Crashing when very large numbers of rows from spreadsheet view are copied (#784) [2025-01-06]
- BUG: Fix filter param layouts when priority layout parameter is linked (#781) [2025-01-06]
- BUG: Update selection mode for MultiPathSelectionWidgets to ExtendedSelection (#787) [2025-01-06]
- ENH/BUG: Remove the workflow mode flag from the preferences file (#786) [2024-12-18]
- BUG: Fix memory leak when visualizing node based geometries (#778) [2024-12-06]
- ENH: Disable use of the point hover info feature on image and rectilinear grid geometries (#775) [2024-12-05]
- BUG: Fixes issue installing DLLs under anaconda builds (#776) [2024-12-05]
- BUG: Block writing of window layout preferences during initialization (#777) [2024-12-04]
- ENH: Add ability to create multiple 2D Charts through splitting of the view (#760) [2024-12-03]

### SIMPLNX 

- BUG FIX: CSV Reader now reads UTF-8 text files correctly. (#1205) [2025-02-24]
- ENH: Excessive Warning Cleanup (#1194) [2025-02-19]
- BUG: Fixes bug where CreateDataArrayAdvanced initializes the arrays twice (#1202) [2025-02-19]
- ENH: Updates array names to have padding digits for SplitAtributeArray. (#1204) [2025-02-18]
- BUG: Disables data transfer from voxels to triangles for SurfaceNets (#1200) [2025-02-14]
- BUG FIX: Read H5Ebsd File now reports image geometry bounds correctly. (#1201) [2025-02-13]
- ENH: Crop Image Geometry now crops by physical units by default. (#1196) [2025-02-11]
- BUG: Fixes Python plugin code generation and creates stub doc file(s) (#1195) [2025-02-10]
- BUG: Fix voxel center assumption for ComputeShapes (#1124) [2025-02-07]
- Updated vcpkg baseline for reproc 14.2.5 (#1192) [2025-02-05]
- Fixed some compiler warnings in simplnx (#1189) [2025-02-04]
- ENH: Geometry Constants Cleanup & GeomTypeToString Method (#1187) [2025-01-31]
- ENH: Fixes algorithm to compute shape factors from Triangle geometry (#1157) [2025-01-28]
- ENH: Add multi component support to MultiThresholdObjectsFilter (#1184) [2025-01-24]
- BUG: DataArray::getComponent should return a value not a reference (#1183) [2025-01-21]
- Fixed formatting (#1182) [2025-01-21]
- BUG: Fix format_pr workflow (#1180) [2025-01-21]
- FILTER: ITK Projection Filters (#1162) [2025-01-16]
- ENH: Improve performance of the Surface Mesh to Regular Grid. (#1146) [2025-01-16]
- ENH: Add slice-by-slice processing option to Isolate Largest Feature. (#1169) [2025-01-14]
- ENH: Update all Alignment Filter documentation to include output file format and explanation (#1170) [2025-01-13]
- BUG: Defends against malformed preferences JSON file or Json content within the file (#1171) [2025-01-10]
- BUG FIX: MeshIO writer code now writes cell data properly. (#1166) [2025-01-06]
- ENH: Use GetAllGeomTypes() method in PartitionGeometryFilter. (#1167) [2025-01-06]
- FILTER: Add WriteNodesAndElementsFiles filter (#1168) [2025-01-03]
- ENH: ReadCSVFile can now read data into existing data groups. (#1164) [2024-12-20]
- ENH: Use more specific parameters instead of generic parameters. (#1165) [2024-12-20]
- ENH: Add support for .ply files and vertex geometries to MeshIO python filters (#1163) [2024-12-19]
- FILTER: Crop Edge Geometry (#1153) [2024-12-11]
- ENH: Fixes high memory consumption in SurfaceNets Filter (#1156) [2024-12-10]
- ENH: Filters use consistent ordering for Spacing and Origin for Image Geometries (#1152) [2024-12-06]
- ENH: Added __iter__() and keys() to BaseGroup python binding (#1159) [2024-12-06]
