```{index} triple: DREAM3D-NX; Release Notes; 7.2.1
```

# 7.2.1

This is the 7.2.1 release. Below are listed the bug fixes and feature additions that have gone into this release.

## Known Issues

- Synthetic Building Filters are not yet implemented
- Long visualization operations can lock up the GUI. Please be patient for those operations to end.
- Compute Feature Centroids will not respect periodic boundaries in a model
- The Anaconda version will not save your GUI window layout correctly. The workaround is to create a layout to your liking and save it as a preset.
- Computing Volumes from Triangle Features will not work correctly unless all triangle normals are consistent and the surface mesh is watertight.

## Feature & Bug Fixes of Note

- ENH: Add custom camera presets (#888)
- ENH: collapsible visualization data view settings widget sections
- BUG: Fix Image Slice View not preserving custom color range when updating slice (#898) [2025-05-30]
- BUG: Fix bug in cell hover picking for non 2D Image/Slice Data Views (#903) [2025-05-30]
- BUG: Fix cell hover info feature for 2D Image Slice (#900) [2025-05-27]
- ENH: Adds feature to show application and system memory usage (#863) [2025-04-14]

- FILTER: Compute Coordinate Threshold (#1319) [2025-06-18]
- FILTER: Split Array (By Tuple) (#1327) [2025-06-13]
- FILTER: Compute Feature Bounds Filter (#1303) [2025-05-27]
- FILTER: Point Sample Edge Geometry (#1286) [2025-05-13]
- FILTER: Add 'Pad Image Geometry' filter to SimplnxCore (#1255) [2025-04-11]
- FILTER: Compute Coordinates Image Geom (#1316) [2025-06-06]

## Fixed Issues

In the below tables are summarized git logs from the commits since the last release. Each line should have a short code at the
start of the line indicate a general area that the commit falls under. Also include is the Github Pull Request (*PR*) number. These can be fully reviewed at:

[https://www.github.com/bluequartzsoftware/simplnx](https://www.github.com/bluequartzsoftware/simplnx)

[https://www.github.com/bluequartzsoftware/DREAM3DNX](https://www.github.com/bluequartzsoftware/DREAM3DNX)

### DREAM3D-NX

- REL: Official 7.2.1 Release [2025-07-19]
- DOC: Update build instructions to better bootstrap the build with NLohmann & VTK (#926) [2025-07-19]
- BUG: Fix crashes when .dream3d file is dragged onto Application Icon in MacOS Dock (#928) [2025-07-19]
- BUG: Fix blocked preflight when dragging through pipeline filter list area (#927) [2025-07-18]
- ENH: Add ability to show/hide the caption annotation handle (#919) [2025-07-17]
- BUG: Fix MacOS crash when OrientationAnalysis Plugin is not compiled. (#925) [2025-07-14]
- BUG: Fix Charting logic when using strings as categories (#921) [2025-07-07]
- BUG: Fix sizing for combo box in color preset dialogs (#922) [2025-07-07]
- BUG: Fix Xcode 15.2 compile error due to use of std::ranges::views (#923) [2025-07-07]
- ENH: Add min/max operators to ArrayCalculator GUI (#920) [2025-07-02]
- DOC: Update documentation to build DREAM3D-NX from scratch. [2025-07-01]
- ENH: Add StringArray Support To ReadCSVFile Filter (#916) [2025-07-01]
- BUG: Fix missing custom camera preset icon [2025-06-26]
- ENH: Add global default color preset options (#918) [2025-06-24]
- BUG: Fix missing connection for resetting the preferences (#917) [2025-06-24]
- ENH: make data set info widget data copyable (#914) [2025-06-23]
- ENH: Convert tooltips to html strings for better formatting with long strings (#915) [2025-06-23]
- ENH: Update vcpkg for fmt, spdlog, and ITK (#913) [2025-06-20]
- BUG: Wait to check range bounds on MinMaxSliderWidget value until user is done typing (#912) [2025-06-19]
- BUG: Add output messages when parsing json fails in AddFilterCommand constructor (#907) [2025-06-18]
- ENH: Add custom camera presets (#888) [2025-06-17]
- ENH: Update Qt-ADS HEAD to fix LICENSE installation clash in Conda builds (#906) [2025-06-16]
- ENH: collapsible visualization data view settings widget sections (#911) [2025-06-13]
- ENH: Move visualization presets to main preference file (#892) [2025-06-12]
- ENH: Improve Visualization Ruler Tool (#905) [2025-06-05]
- ENH: Convert custom tooltips back to regular tooltips & add help link button (#891) [2025-06-02]
- ENH: Add units input option to the visualization ruler tool (#899) [2025-05-30]
- BUG: Fix Image Slice View not preserving custom color range when updating slice (#898) [2025-05-30]
- BUG: Fix bug in cell hover picking for non 2D Image/Slice Data Views (#903) [2025-05-30]
- BUG: Fix cell hover info feature for 2D Image Slice (#900) [2025-05-27]
- ENH: Indexed Color Lookup Table Options (#879) [2025-05-27]
- BUG: Items are checked properly when dragging in a .dream3d file. (#896) [2025-05-27]
- ENH: Add solid color option to the default settings & separate solid color from color by drop down menu (#889) [2025-05-20]
- ENH: Allow range sliders min/max values to change dynamically based on text field values  (#890) [2025-05-20]
- ENH: Update the example file name in the generated file list parameter (#887) [2025-05-16]
- ENH: Remove generation of 'OriginalCellIds' array (#885) [2025-05-13]
- ENH: Change capture screenshot wording to save screenshot for clarity (#886) [2025-05-12]
- BUG: Fix initializing the read dream3d file filter parameter from drag and drop (#884) [2025-05-09]
- BUG: Fix constructor arguments for NXFilter (#883) [2025-05-08]
- BUG: Allow NXFilter to not construct the filter's widget (#881) [2025-05-07]
- ENH: Calculate & show the cell centroid in the visualization cell hover info (#882) [2025-05-07]
- ENH: Add preference for camera parallel projection (#880) [2025-05-05]
- ENH: Add Offline License Activation Option (#873) [2025-04-24]
- BUG: rescale data to range when switching between arrays/components (#878) [2025-04-24]
- COMP: Fix macOS packaging errors with TLS Qt plugins. (#877) [2025-04-24]
- BUG: Fix Chart Axes Number Format (#876) [2025-04-24]
- ENH: Optimize leaf path algorithm in NXDream3dImportWidget. (#875) [2025-04-17]
- BUG: Clear the filter fault states for filter index icons when executing (#874) [2025-04-17]
- ENH: Visualization Settings Widget Improvements (#869) [2025-04-16]
- BUG: Fix drag & drop Urls for certain Linux OS (#872) [2025-04-15]
- BUG: Check for nullptr for vtkAlgorithm output in VXInfoWidget (#866) [2025-04-15]
- ENH: Condense all menu bar code into a single location (#855) [2025-04-15]
- ENH: Adds feature to show application and system memory usage (#863) [2025-04-14]
- BUG: Fix 2D Image/Slice view bounds. (#870) [2025-04-11]
- COMP: Cleanup compiler warnings to move towards -Wall compliance. (#862) [2025-04-10]
- ENH: Update code to support new OoC HDF5 reader classes (#868) [2025-04-10]
- BUG FIX: Fixed issue where NXDream3dImportWidget was sending extra paths to its simplnx parameter. (#867) [2025-04-03]
- ENH: Advanced Vis Slice View Features (#845) [2025-04-02]
- BUG: Ensures at least 5 characters for NXComboBoxes. (#861) [2025-03-31]
- COMP: Misc. compiler warning cleanups. (#859) [2025-03-31]
- ENH: Support added for Dream3dImportParameter changes. (#846) [2025-03-26]

### SIMPLNX 

- BUG: ReadCSVFile filter now properly uses the filter's instance id. (#1367) [2025-07-19]
- BUG: Fix Import DREAM3D Memory Usage (#1341) [2025-07-17]
- ENH: Add 'swap' method to IDataArray and implementations in subclasses. (#1347) [2025-07-15]
- BUG: Set attribute on temp directory to force Dropbox to not sync temp files (#1362) [2025-07-11]
- ENH: Add progress feedback to RotateEulerRefFrame (#1360) [2025-07-10]
- ENH: Add option to keep input geometry origin for RotateSampleRefFrame Filter (#1355) [2025-07-03]
- ENH: Allow existing geometry in RegularGridSampleSampleSurfaceMesh (#1344) [2025-07-03]
- ENH: Add min/max operators to Array Calculator filter. (#1351) [2025-07-02]
- DOC: Add missing documentation for Randomize FeatureIds Filer (#1348) [2025-07-01]
- ENH: Creates an edge geometry that visualize bounding boxes (#1326) [2025-07-01]
- ENH: Add StringArray Support To ReadCSVFile Filter (#1339) [2025-06-30]
- BUG: Fix out-of-bounds array access in RequireMinNumNeighbors Filter (#1343) [2025-06-30]
- ENH: Improved threadsafe messaging (#1340) [2025-06-30]
- ENH: Add Randomize FeatureI ds utility and filter (#1306) [2025-06-24]
- BUG: Fix Hardcoded Element List Name to Match SIMPL (#1336) [2025-06-20]
- BUG: Misc Image Geometry Bug Fixes (#1328) [2025-06-20]
- ENH: Update vcpkg for fmt, spdlog, and ITK (#1333) [2025-06-20]
- BUG: RequireMinNumNeighbors DataArray Update fixes (#1320) [2025-06-19]
- ENH: Allow "Segment Features" to consider periodic microstructures (#1291) [2025-06-18]
- FILT: Compute Coordinate Threshold (#1319) [2025-06-18]
- ENH: Replace C style 2D arrays with Eigen::Matrix (#1324) [2025-06-17]
- FILT: Split Array (By Tuple) (#1327) [2025-06-13]
- FILT: Compute Coordinates Image Geom (#1316) [2025-06-06]
- ENH: ComputeFeatureShapesTriangleGeom algorithm parallelization (#1307) [2025-06-05]
- PY: Added NeighborList python bindings (#1314) [2025-06-02]
- FILT: Compute Feature Bounds Filter (#1303) [2025-05-27]
- BUG: Fix RequireMinNumNeighbors Not Using Ignore Paths (#1310) [2025-05-24]
- ENH: Clarify Kernel Average Misorientation algorithm with proper casting. (#1305) [2025-05-23]
- BUG: Range check Compute Triangle Feature Volumes (#1309) [2025-05-23]
- ENH: Update ValidateFeatureIdsToFeatureAttributeMatrixIndexing API (#1308) [2025-05-23]
- STYLE/PERF: Remove Deprecated Test Files and Remove Dead Code in Test Case (#1302) [2025-05-16]
- ENH: Compute Array Statistics - Range Gating and Histogram Migration (#1288) [2025-05-15]
- ENH: Updates codes to use MakeErrorResult() for better readability (#1297) [2025-05-14]
- ENH: Ensure all filters are checking for cancel and sending progress messages. (#1267) [2025-05-13]
- ENH: Add Fill Functionality to Create Array Action & Utility File Refactoring (#1295) [2025-05-13]
- FILT: Point Sample Edge Geometry (#1286) [2025-05-13]
- ENH: Add function to generate an example file name for the generated file list parameter (#1296) [2025-05-13]
- ENH: Add ability to append to a DREAM3D file (#1294) [2025-05-09]
- COMP: Misc. compiler warning cleanups. (#1249) [2025-05-08]
- ENH: Add functions to support loading indexed color presets (#1289) [2025-05-07]
- ENH: Assign -1.0 to all values if triangle mesh is non-conformant. (#1293) [2025-05-06]
- ENH: Verify Triangle Windings Filter and Meshing Util API Expansion (#1279) [2025-05-02]
- ENH: Update conda and vcpkg to use EbsdLib 1.0.38 (#1290) [2025-05-02]
- ENH: Crop Image Geometry now displays input image info even if there are filter errors. (#1287) [2025-05-01]
- ENH: Add Euler Characteristic computation to Compute Triangle Geometry Shapes (#1280) [2025-04-24]
- BUG: Ensure FeatureId arrays are range checked against the Feature Attribute Matrix. (#1278) [2025-04-24]
- BUG: Fix incorrect logic to validate usage of existing attribute matrix (#1275) [2025-04-22]
- ENH: Updated python filter template to show correct way to cancel (#1268) [2025-04-15]
- ENH: Make Dummy Node Optional in Abaqus Hexahedron Writer (#1265) [2025-04-15]
- ENH: Show EBSD Phase Info in Preflight Updated Values for each EBSD readers (#1263) [2025-04-11]
- COMP: Fix missing include directive for <algorithm> (#1266) [2025-04-11]
- FILT: Add 'Pad Image Geometry' filter to SimplnxCore (#1255) [2025-04-11]
- ENH: Pull out CSV Reader helper methods to FileUtilities::CSV (#1261) [2025-04-11]
- ENH: Remove Matrix3x3 and Matrix3x1 classes. Use Eigen instead. (#1258) [2025-04-10]
- BUG: Fix the embedded names of example pipelines and parameter warnings. (#1256) [2025-04-10]
- ENH: Fixes empty exception messages. (#1246) [2025-04-10]
- BUG: Reads and Writes the length units for geometries. (#1251) [2025-04-10]
- ENH: Add missing documentation comments for preflight and execute methods in filters (#1257) [2025-04-10]
- ENH: Update to EbsdLib 1.0.38 (#1259) [2025-04-10]
- ENH: Merge Initial Out-of-Core infrastructure (#1253) [2025-04-09]
- ENH: Dream3dImportParameter supports additional import options. (#1230) [2025-03-26]
